<?php  
include "sidebar.php";
include "header.php";
?>
<div class="app-content content container-fluid">
	<div class="content-wrapper">
		<div class="content-body">
			<div class="row">
				<div class="col-xs-12">
					<div class="card">
						<div class="card-header">
							<h4 class="card-title">All Top Songs</h4>
							<a class="heading-elements-toggle"><i class="icon-ellipsis font-medium-3"></i></a>
							<div class="heading-elements">
								<ul class="list-inline mb-0">
									<li><a data-action="collapse"><i class="icon-minus4"></i></a></li>
									<li><a data-action="reload"><i class="icon-reload"></i></a></li>
									<li><button type="button" class="btn btn-primary" data-toggle="modal" data-target="#myModal">Add  New Top Song</button></li>
								</ul>
							</div>
						</div>
						<div class="card-body collapse in">
							<div class="card-block card-dashboard">
								<div class="table-responsive">
									<table class="table">
										<thead>
											<tr>
												<th>S.No.</th>
												<th>Title</th>
												<th>Singer</th>
												<th>Mp3</th>
												<th>Edit</th>
												<th>Delete</th>
											</tr>
										</thead>
										
										<tbody>
										<?php 
											$query = $con->query("select * from top_songs ORDER BY position ASC");
											$i= 1;
											while($row = $query->fetch_assoc()){
												//print_r($row);
											?>
											<tr>
												<th scope="row"><?php echo $i; ?></th>
												<td><?php echo $row['title']; ?></td>
												<td><?php echo $row['singer']; ?></td>
												<td><audio controls controlsList="nodownload" preload='auto' autobuffer class="audio_volume_only" loop="loop">
												<source src="audio/<?php echo $row['mp3']; ?>" type="audio/ogg">
												<source src="audio/<?php echo $row['mp3']; ?>" type="audio/mpeg">
												</audio>
												</td>
												<td><a href="edit-song?id=<?php echo $row['tid']; ?>" class="btn btn-primary"><i class="icon-edit2"></i></a></td>
												<td><a href="delete.php?vid=<?php echo $row['tid']; ?>" class="btn btn-danger"><i class="icon-trash2"></i></a></td>
											</tr>
											<?php
											$i++;
											} ?>
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<!-- Basic Tables end -->
<!-- Modal -->
<div id="myModal" class="modal fade" role="dialog">
	<div class="modal-dialog">

    <!-- Modal content-->
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<div class="modal-body">
				<div class="content-wrapper">
					<div class="content-body">
						<div class="row">
							<div class="col-xs-12">
							<?php include "core/form-submission.php"; ?>
								<form class="form" method="POST" enctype="multipart/form-data">
									<div class="form-body">
										<h4 class="form-section"><i class="icon-music"></i>Add New Song</h4>
										<div class="form-group">
											<label for="userinput5">Title</label>
											<input class="form-control border-primary" name="title" type="text" placeholder="Title" id="userinput5" required />
										</div>
										<div class="form-group">
											<label for="userinput6">Singer</label>
											<input class="form-control border-primary" name="singer" type="text" placeholder="Singer" id="userinput6"required />
										</div>
										<div class="form-group">
											<label>Image</label>
											<input class="form-control border-primary" id="userinput7" type="file" name="logo" placeholder="Image" required />
										</div>
										<div class="form-group">
											<label for="userinput8">Mp3</label>
											<input id="userinput8" type="file" class="form-control border-primary" name="mp3" placeholder="Mp3" required />
										</div>
										<div class="form-group">
											<label for="userinput8">Position</label>
											<select class="form-control border-primary" name="position">
											<?php
											$arr = array("1", "2", "3", "4", "5", "6", "7", "8", "9", "10");
											?>
											<option>Select Position</option>
											<?php
											foreach($arr as $val){
											?>
											<option value="<?php echo $val; ?>"><?php echo $val; ?></option>
											<?php
											}
											?>
											</select>
										</div>
									</div>
									<div class="form-actions left">
										<button type="submit" class="btn btn-primary" name="add-song">
											<i class="icon-check2"></i> Save
										</button>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			</div>
		</div>
	</div>
</div>
<?php include "footer.php"; ?>
